package com.jugg.agile.middleware.db.mybatis.config;

import com.jugg.agile.framework.core.config.JaPrePropertyHandler;

/**
 * mybatis.configuration 默认配置
 *
 * @author chenjian
 * @since 2024年03月31日 20:14:25
 */
public class JaMybatisConfigurationPropertyHandler implements JaPrePropertyHandler {
    @Override
    public void addAndCover() {
        // https://mybatis.org/mybatis-3/zh_CN/configuration.html#settings

        // 全局性地开启或关闭所有映射器配置文件中已配置的任何缓存, 默认true
        addAndCover("mybatis.configuration.cacheEnabled", false);

        // 返回代理对象, 级联查询会懒加载, 默认false
//        addAndCover("mybatis.configuration.lazyLoadingEnabled", false);
//        addAndCover("mybatis.configuration.aggressiveLazyLoading", false);

        // 是否允许单个语句返回多结果集（需要数据库驱动支持）, 默认true, 在 3.4.1 及之前的版本中默认为 true
        addAndCover("mybatis.configuration.multipleResultSetsEnabled", true);

        // 使用列标签代替列名。实际表现依赖于数据库驱动，具体可参考数据库驱动的相关文档，或通过对比测试来观察
        // org.apache.ibatis.executor.resultset.ResultSetWrapper.ResultSetWrapper
        // columnNames.add(configuration.isUseColumnLabel() ? metaData.getColumnLabel(i) : metaData.getColumnName(i))
        // org.apache.ibatis.executor.resultset.DefaultResultSetHandler.applyAutomaticMappings
        // final Object value = mapping.typeHandler.getResult(rsw.getResultSet(), mapping.column);
        // org.apache.ibatis.type.StringTypeHandler.getNullableResult(java.sql.ResultSet, java.lang.String)
        // rs.getString(columnName); columnName未使用别名, ResultSet获取不到
        // 对应jdbc useColumnNamesInFindColumn
        // com.mysql.cj.jdbc.result.ResultSetImpl.findColumn; 获取不到列index
        // false : 不获取别名, 默认true
//        addAndCover("mybatis.configuration.useColumnLabel", true);

        addAndCover("mybatis.configuration.mapUnderscoreToCamelCase", true);

        // public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        // return cachedInvoker(method).invoke(proxy, method, args, sqlSession);
        // org.apache.ibatis.binding.MapperProxy.PlainMethodInvoker.invoke
        // org.apache.ibatis.binding.MapperMethod.execute
        // org.mybatis.spring.SqlSessionTemplate.insert(java.lang.String, java.lang.Object)
        // org.apache.ibatis.session.defaults.DefaultSqlSession.insert(java.lang.String, java.lang.Object)
        // org.apache.ibatis.executor.statement.BaseStatementHandler.BaseStatementHandler
        // generateKeys(parameterObject);
        // org.apache.ibatis.executor.SimpleExecutor.doUpdate
        // return handler.update(stmt);
        // org.apache.ibatis.executor.statement.PreparedStatementHandler.update
        // com.zaxxer.hikari.pool.ProxyStatement.getGeneratedKeys
        // com.mysql.cj.jdbc.StatementImpl.getGeneratedKeys
        // com.mysql.cj.jdbc.StatementImpl.getLastInsertID
        // 核心 : org.apache.ibatis.executor.statement.PreparedStatementHandler.update
        // keyGenerator.processAfter(executor, mappedStatement, ps, parameterObject);
        // 默认值是 falsem, 必须结合 <insert id="insertSelective" parameterType="com.kael.test.dao.pojo.po.OrderPO" keyProperty="id">
        // keyProperty="id"
        // 启动时则开始识别是否处理 isUseGeneratedKeys org.apache.ibatis.mapping.MappedStatement.Builder.Builder
        // mappedStatement.keyGenerator = configuration.isUseGeneratedKeys() && SqlCommandType.INSERT.equals(sqlCommandType) ? Jdbc3KeyGenerator.INSTANCE : NoKeyGenerator.INSTANCE
        // xml 构建参数 org.apache.ibatis.builder.xml.XMLStatementBuilder.parseStatementNode
        // set 自增字段 org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator.assignKeysToParam
        addAndCover("mybatis.configuration.useGeneratedKeys", true);
    }

    @Override
    public int order() {
        return -100;
    }
}
