/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.datasource.aspect;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarm;
import com.jugg.agile.framework.core.dapper.alarm.JaNotify;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.db.datasource.JaDataSourceFactory;
import com.jugg.agile.middleware.db.datasource.JaDataSourceRoute;
import com.jugg.agile.middleware.db.datasource.meta.JaDataSourceAnnotation;
import com.jugg.agile.middleware.db.transaction.JaTransactionProcessor;
import com.zaxxer.hikari.HikariDataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
public class JaConnectionAspect {
    private static long timeout;

    @Pointcut(value="execution(* javax.sql.DataSource.getConnection())")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Around(value="pointcut()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        block24: {
            block23: {
                block22: {
                    start = System.currentTimeMillis();
                    try {
                        route = (JaDataSourceAnnotation)JaDataSourceRoute.getRoute().get();
                        if (null != route) break block22;
                        var5_4 = pjp.proceed();
                    }
                    catch (Throwable var14_24) {
                        end = System.currentTimeMillis() - start;
                        if (end > JaConnectionAspect.timeout) {
                            try {
                                target = pjp.getTarget();
                                poolName = "";
                                if (target instanceof HikariDataSource) {
                                    poolName = ((HikariDataSource)target).getPoolName();
                                }
                                error = String.format("javax.sql.DataSource.getConnection poolName:%s timeout: %s > %s", new Object[]{poolName, end, JaConnectionAspect.timeout});
                                JaAlarm.getAlarmHandler().apply((Object)(JaNotify.getCommonMessage() + error));
                                JaLog.info((String)error, (Object[])new Object[0]);
                            }
                            catch (Throwable e) {
                                JaLog.error((String)"javax.sql.DataSource.getConnection timeout alarm error", (Object[])new Object[]{e});
                            }
                        }
                        throw var14_24;
                    }
                    end = System.currentTimeMillis() - start;
                    if (end > JaConnectionAspect.timeout) {
                        try {
                            target = pjp.getTarget();
                            poolName = "";
                            if (target instanceof HikariDataSource) {
                                poolName = ((HikariDataSource)target).getPoolName();
                            }
                            error = String.format("javax.sql.DataSource.getConnection poolName:%s timeout: %s > %s", new Object[]{poolName, end, JaConnectionAspect.timeout});
                            JaAlarm.getAlarmHandler().apply((Object)(JaNotify.getCommonMessage() + error));
                            JaLog.info((String)error, (Object[])new Object[0]);
                        }
                        catch (Throwable e) {
                            JaLog.error((String)"javax.sql.DataSource.getConnection timeout alarm error", (Object[])new Object[]{e});
                        }
                    }
                    return var5_4;
                }
                dataSource = null;
                dataSourcePool = JaDataSourceFactory.get();
                if (!JaCollectionUtil.isNotEmpty(dataSourcePool)) ** GOTO lbl66
                if (!route.isSlaver() || !TransactionSynchronizationManager.isActualTransactionActive() && !JaTransactionProcessor.isBeginSpringTx()) ** GOTO lbl64
                master = route.getMaster();
                if (JaStringUtil.isNotEmpty((String)master)) {
                    dataSource = dataSourcePool.get(master);
                    break block23;
                }
                JaLog.get().debug("datasource route slave by : master");
                e = pjp.proceed();
                end = System.currentTimeMillis() - start;
                if (end > JaConnectionAspect.timeout) {
                    try {
                        target = pjp.getTarget();
                        poolName = "";
                        if (target instanceof HikariDataSource) {
                            poolName = ((HikariDataSource)target).getPoolName();
                        }
                        error = String.format("javax.sql.DataSource.getConnection poolName:%s timeout: %s > %s", new Object[]{poolName, end, JaConnectionAspect.timeout});
                        JaAlarm.getAlarmHandler().apply((Object)(JaNotify.getCommonMessage() + error));
                        JaLog.info((String)error, (Object[])new Object[0]);
                    }
                    catch (Throwable e) {
                        JaLog.error((String)"javax.sql.DataSource.getConnection timeout alarm error", (Object[])new Object[]{e});
                    }
                }
                return e;
            }
            break block24;
lbl64:
            // 1 sources

            JaLog.get().debug("datasource route by : {}", (Object)route.getName());
            dataSource = dataSourcePool.get(route.getName());
        }
        if (null == dataSource) {
            throw new RuntimeException("switch datasource error, datasource is null : " + route.getName());
        }
        JaLog.get().debug("datasource route by : {}", (Object)route.getName());
        var7_17 = dataSource.getConnection();
        end = System.currentTimeMillis() - start;
        if (end > JaConnectionAspect.timeout) {
            try {
                target = pjp.getTarget();
                poolName = "";
                if (target instanceof HikariDataSource) {
                    poolName = ((HikariDataSource)target).getPoolName();
                }
                error = String.format("javax.sql.DataSource.getConnection poolName:%s timeout: %s > %s", new Object[]{poolName, end, JaConnectionAspect.timeout});
                JaAlarm.getAlarmHandler().apply((Object)(JaNotify.getCommonMessage() + error));
                JaLog.info((String)error, (Object[])new Object[0]);
            }
            catch (Throwable e) {
                JaLog.error((String)"javax.sql.DataSource.getConnection timeout alarm error", (Object[])new Object[]{e});
            }
        }
        return var7_17;
    }

    static {
        JaPropertyListener.addAndRunCommonListener(() -> {
            timeout = JaProperty.getLong((String)"ja.log.dapper.common.timeout.db-conn", (Long)1000L);
        });
    }
}

