package com.jugg.agile.middleware.db.datasource.config;

import com.jugg.agile.middleware.db.jdbc.config.JdbcPropertyConfig;
import com.jugg.agile.middleware.db.jdbc.config.JdbcUrlConfig;
import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class JaDataSourceConfig {
    private String database;

    private String ip;
    private String port;
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private int initialSize = 5;
    private int maxActive = 20;
    private int minIdle = 5;
    private long maxLifetime = 30000;
    private int connectionTimeout = 5000;
    private JdbcPropertyConfig jdbcProperty = new JdbcPropertyConfig();
    private JdbcUrlConfig jdbcUrlParam = new JdbcUrlConfig();

}
