package com.jugg.agile.middleware.db.jdbc.mysql;

import com.jugg.agile.middleware.db.jdbc.JaJdbcStatementProcessor;

import java.sql.Connection;
import java.util.List;
import java.util.Map;

/**
 * desc
 *
 * @author chenjian
 * @since 2024年03月31日 20:12:56
 */
public class JaMysqlDescProcessor {

    public static List<Map<String, Object>> descTable(Connection connection, String tableName) {
        return JaJdbcStatementProcessor.executeQuery(connection
                , String.format("desc `%s`", tableName));
    }

    public static String getAutoIncrementColumn(Connection connection, String tableName) {
        List<Map<String, Object>> tableInfo = JaMysqlDescProcessor.descTable(connection, tableName);
        for (Map<String, Object> rowInfo : tableInfo) {
            Object exrta = rowInfo.get("EXTRA");
            if (null != exrta && exrta.toString().contains("auto_increment")) {
                return rowInfo.get("COLUMN_NAME").toString();
            }
        }
        return null;
    }
}
