package com.jugg.agile.middleware.db.mybatis.generator;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * mybatis generator 执行入参
 *
 * @author chenjian
 * @since 2024年03月31日 20:18:13
 */
@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class JaMybatisGeneratorXmlParams {

    /**
     * resources下的 xml文件
     */
    private String xmlPath;

    /**
     * pojo 包路径
     */
    private String pojoPackage;
    /**
     * 项目路径
     */
    private String pojoTargetProject;

    /**
     * pojo 类名后缀
     */
    private String pojoSuffix;

    /**
     * mapper xml 路径
     */
    private String mapperXmlPackage;
    /**
     * mapper xml resources 路径
     */
    private String mapperXmlTargetProject;

    /**
     * mapper interface 路径
     */
    private String mapperPackage;
    /**
     * mapper interface 项目路径
     */
    private String mapperTargetProject;
    /**
     * mapper interface 后缀
     */
    private String mapperSuffix;

    private String ip;
    private String port;
    private String database;
    private String userId;
    private String password;
}
