package com.jugg.agile.middleware.db.transaction;

import com.jugg.agile.middleware.db.transaction.meta.JaTransactional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.AnnotatedElement;

public class JaTransactionProcessor {
    private static final String springTxStackClass = "org.springframework.jdbc.datasource.DataSourceTransactionManager";
    private static final String springTxStackMethod = "doBegin";

    public static boolean isBeginSpringTx() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (stackTraceElement.getClassName().equals(springTxStackClass)
                    && stackTraceElement.getMethodName().equals(springTxStackMethod)) {
                return true;
            }
        }
        return false;
    }

    @JaTransactional("demo")
    public void test() {

    }

    public static void main(String[] args) throws NoSuchMethodException {
        Object test = JaTransactionProcessor.class.getDeclaredMethod("test");
        AnnotationAttributes mergedAnnotationAttributes = AnnotatedElementUtils.findMergedAnnotationAttributes((AnnotatedElement) test, Transactional.class, false, false);
//        isBeginSpringTx();
    }
}
