package com.jugg.agile.middleware.kafka.producer;

import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

import java.util.Properties;
import java.util.concurrent.Future;

/**
 * 默认 KafkaProducer<String, String>
 *
 * @author chenjian
 * @since 2025年09月08日 15:14:24
 */
public class JaKafkaProducer extends KafkaProducer<String, String> {
    public JaKafkaProducer(Properties properties) {
        super(properties);
    }

    public <T> Future<RecordMetadata> send(String topic, String key, T message) {
        return this.send(new ProducerRecord<>(topic, key, JaJson.toString(message)));
    }
}
