/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.kafka.test;

import com.alibaba.fastjson.JSON;
import com.jugg.agile.middleware.kafka.test.LogMessage;
import java.time.Duration;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;

public class LogKafkaProducer {
    private Producer<String, String> producer;
    private String topicName;
    private volatile long errorCount = 0L;
    private volatile long lastErrorLogTime = 0L;

    public LogKafkaProducer(String topicName) {
        this.topicName = topicName;
        this.producer = this.createProducer();
    }

    private Producer<String, String> createProducer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "10.176.187.18:9092,10.176.187.17:9092,10.176.187.16:9092");
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("acks", "0");
        props.put("retries", (Object)0);
        props.put("request.timeout.ms", (Object)3000);
        props.put("delivery.timeout.ms", (Object)5000);
        props.put("batch.size", (Object)32768);
        props.put("linger.ms", (Object)50);
        props.put("buffer.memory", (Object)0x1000000);
        props.put("compression.type", "none");
        props.put("enable.idempotence", (Object)false);
        props.put("max.in.flight.requests.per.connection", (Object)2);
        props.put("send.buffer.bytes", (Object)65536);
        props.put("receive.buffer.bytes", (Object)32768);
        props.put("connections.max.idle.ms", (Object)120000);
        props.put("metadata.max.age.ms", (Object)300000);
        props.put("max.block.ms", (Object)100);
        props.put("client.id", "log-producer-" + System.currentTimeMillis());
        props.put("partitioner.class", "org.apache.kafka.clients.producer.internals.DefaultPartitioner");
        return new KafkaProducer(props);
    }

    public void sendLogSilentMode(String logJson, String traceId) {
        try {
            ProducerRecord record = new ProducerRecord(this.topicName, (Object)traceId, (Object)logJson);
            this.producer.send(record);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendLogWithErrorCount(String logJson, String traceId) {
        try {
            ProducerRecord record = new ProducerRecord(this.topicName, (Object)traceId, (Object)logJson);
            this.producer.send(record, (metadata, exception) -> {
                if (exception != null) {
                    ++this.errorCount;
                    long now = System.currentTimeMillis();
                    if (now - this.lastErrorLogTime > 10000L) {
                        System.err.println("Log send errors in last period: " + this.errorCount);
                        this.lastErrorLogTime = now;
                        this.errorCount = 0L;
                    }
                }
            });
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void sendLog(String logJson, String traceId) {
        ProducerRecord record = new ProducerRecord(this.topicName, (Object)traceId, (Object)logJson);
        this.producer.send(record, (metadata, exception) -> {
            if (exception != null) {
                System.err.println("Log send failed: " + exception.getMessage());
            }
        });
    }

    public void flush() {
        try {
            this.producer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.producer != null) {
            try {
                this.producer.close(Duration.ofSeconds(5L));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        LogKafkaProducer logProducer = new LogKafkaProducer("log-topic");
        LogMessage logMessage = new LogMessage();
        logMessage.setTime(System.currentTimeMillis());
        logMessage.setThread("main");
        logMessage.setTraceId("trace-123456");
        logMessage.setSpanId("span-001");
        logMessage.setLevel("INFO");
        logMessage.setLoggerName("com.example.LogService");
        logMessage.setNodeType("application");
        logMessage.setType("business");
        logMessage.setNodeId("node-001");
        logMessage.setCurrentNodeSpanId("current-span-001");
        logMessage.setTimeConsume(150L);
        logMessage.setParamSize(1024);
        logMessage.setCustomContent("\u7528\u6237\u767b\u5f55");
        logMessage.setMessage("\u7528\u6237\u767b\u5f55\u6210\u529f");
        logMessage.setThrowable(null);
        logMessage.setAppId("my-app");
        logMessage.setSource("hostname-001");
        logMessage.setAppender("kafka");
        logMessage.setModifyDate(System.currentTimeMillis());
        logMessage.setCreateDate(System.currentTimeMillis());
        String logJson = JSON.toJSONString((Object)logMessage);
        logProducer.sendLog(logJson, logMessage.getTraceId());
        logProducer.flush();
        logProducer.close();
        long errors = logProducer.getErrorCount();
        if (errors > 100L) {
            // empty if block
        }
    }
}

