/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.kafka.test;

import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class TestKafkaConsumerLocal {
    private final AtomicBoolean running = new AtomicBoolean(true);
    private KafkaConsumer<String, String> consumer;

    public static void main(String[] args) {
        TestKafkaConsumerLocal continuousConsumer = new TestKafkaConsumerLocal();
        continuousConsumer.start();
        Runtime.getRuntime().addShutdownHook(new Thread(continuousConsumer::shutdown));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9092");
        props.put("group.id", "test-consumer-group");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "1000");
        props.put("auto.offset.reset", "earliest");
        this.consumer = new KafkaConsumer(props);
        this.consumer.subscribe(Collections.singletonList("test-topic"));
        System.out.println("\u5f00\u59cb\u6301\u7eed\u76d1\u542c\u6d88\u606f\uff0c\u6309Ctrl+C\u9000\u51fa...");
        try {
            while (this.running.get()) {
                ConsumerRecords records = this.consumer.poll(Duration.ofMillis(1000L));
                for (ConsumerRecord record : records) {
                    System.out.printf("\u6536\u5230\u6d88\u606f: \u4e3b\u9898=%s, \u5206\u533a=%d, \u504f\u79fb\u91cf=%d, \u952e=%s, \u503c=%s%n", record.topic(), record.partition(), record.offset(), record.key(), record.value());
                    this.processMessage((String)record.value());
                }
            }
        }
        catch (WakeupException e) {
            if (!this.running.get()) {
                System.out.println("\u6d88\u8d39\u8005\u6b63\u5728\u5173\u95ed...");
            }
        }
        finally {
            this.consumer.close();
            System.out.println("\u6d88\u8d39\u8005\u5df2\u5173\u95ed");
        }
    }

    private void processMessage(String message) {
        System.out.println("\u5904\u7406\u6d88\u606f: " + message);
    }

    public void shutdown() {
        this.running.set(false);
        if (this.consumer != null) {
            this.consumer.wakeup();
        }
    }
}

