/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.kafka.test;

import com.alibaba.fastjson.JSON;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class TestKafkaProducer {
    public static void main(String[] args) throws ExecutionException, InterruptedException {
        Properties props = new Properties();
        props.put("bootstrap.servers", "10.176.187.18:9092,10.176.187.17:9092,10.176.187.16:9092");
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("acks", "all");
        props.put("buffer.memory", (Object)0x2000000);
        props.put("compression.type", "none");
        props.put("batch.size", (Object)6144);
        props.put("linger.ms", (Object)10);
        props.put("retries", (Object)3);
        props.put("max.in.flight.requests.per.connection", (Object)1);
        props.put("enable.idempotence", (Object)true);
        KafkaProducer producer = new KafkaProducer(props);
        ProducerRecord producerRecord = new ProducerRecord("testTopic", (Object)"key", (Object)"value");
        Callback callback = new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                System.out.println("metadata" + JSON.toJSONString((Object)metadata));
                System.out.println("metadata -> " + metadata.partition());
                System.out.println("exception" + JSON.toJSONString((Object)exception));
            }
        };
        Future testTopic = producer.send(producerRecord, callback);
        System.out.println(JSON.toJSONString((Object)testTopic));
        System.out.println(JSON.toJSONString(testTopic.get()));
        producer.close();
    }
}

