/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.kafka.producer;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.StringSerializer;

public class JaKafkaProducerProcessor {
    private JaKafkaProducerProcessor() {
    }

    public static Properties wrapProperties(Properties kafkaProperties) {
        kafkaProperties.putIfAbsent("key.serializer", StringSerializer.class.getName());
        kafkaProperties.putIfAbsent("value.serializer", StringSerializer.class.getName());
        kafkaProperties.put("acks", kafkaProperties.get("acks") + "");
        return kafkaProperties;
    }

    public static Map<String, Properties> getPropertiesMap() {
        String prefix = "ja.kafka.producer";
        Map propertiesMap = JaYamlProcessor.getProperties((Map)JaYamlProcessor.getMap((Map)JaProperty.getPropertyMap(), (String)prefix), (String)prefix);
        propertiesMap.forEach((k, v) -> JaKafkaProducerProcessor.wrapProperties(v));
        return propertiesMap;
    }

    public static Producer<String, String> createProducer(Properties properties) {
        return new KafkaProducer(JaKafkaProducerProcessor.wrapProperties(properties));
    }
}

