package com.jugg.agile.middleware.kafka.producer;

import org.apache.kafka.common.serialization.StringSerializer;

import java.util.Properties;

public class JaKafkaProducerProcessor {
    private JaKafkaProducerProcessor() {
    }

    public static Properties wrapProperties(Properties kafkaProperties) {
        kafkaProperties.putIfAbsent("key.serializer", StringSerializer.class.getName());
        kafkaProperties.putIfAbsent("value.serializer", StringSerializer.class.getName());
        kafkaProperties.put("acks", kafkaProperties.get("acks") + "");
        return kafkaProperties;
    }
}
