package com.jugg.agile.middleware.kafka.config;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import org.apache.kafka.common.serialization.StringSerializer;

import java.util.Map;
import java.util.Properties;

public class JaKafkaProducerConfigProcessor {

    public static void main(String[] args) {
        JaProperty.put("ja.demo", "demo");
        JaProperty.put("ja.kafka.producer.lmc.bootstrap.servers", "10.176.187.18:9092,10.176.187.17:9092,10.176.187.16:9092");
        JaProperty.put("ja.kafka.producer.lmc.key.serializer", StringSerializer.class.getName());
        JaProperty.put("ja.kafka.producer.lmc.value.serializer", StringSerializer.class.getName());
        JaProperty.put("ja.kafka.producer.lmc.acks", 0);
        JaProperty.put("ja.kafka.producer.lmc.retries", 0);

        JaProperty.put("ja.kafka.producer.demo.bootstrap.servers", "10.176.187.18:9092,10.176.187.17:9092,10.176.187.16:9092");
        JaProperty.put("ja.kafka.producer.demo.key.serializer", StringSerializer.class.getName());
        JaProperty.put("ja.kafka.producer.demo.value.serializer", StringSerializer.class.getName());
        JaProperty.put("ja.kafka.producer.demo.acks", 0);
        JaProperty.put("ja.kafka.producer.demo.retries", 0);

        Map<String, Object> map = JaYamlProcessor.getMap(JaProperty.getPropertyMap(), "ja.kafka.producer");

        Map<String, Properties> properties = JaYamlProcessor.getProperties(JaProperty.getPropertyMap(), "ja.kafka.producer");

        System.out.println();
    }
}
