package com.jugg.agile.middleware.kafka.producer;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import org.apache.kafka.common.serialization.StringSerializer;

import java.util.Map;
import java.util.Properties;

public class JaKafkaProducerProcessor {
    private JaKafkaProducerProcessor() {
    }

    public static Properties wrapProperties(Properties kafkaProperties) {
        kafkaProperties.putIfAbsent("key.serializer", StringSerializer.class.getName());
        kafkaProperties.putIfAbsent("value.serializer", StringSerializer.class.getName());
        kafkaProperties.put("acks", kafkaProperties.get("acks") + "");
        return kafkaProperties;
    }

    public static Map<String, Properties> getPropertiesMap(){
        String prefix = "ja.kafka.producer";
        Map<String, Properties> propertiesMap = JaYamlProcessor.getProperties(JaYamlProcessor.getMap(JaProperty.getPropertyMap(), prefix), "ja.kafka.producer");
        propertiesMap.forEach((k, v) -> wrapProperties(v));
        return propertiesMap;
    }
}
