package com.jugg.agile.middleware.mongodb.spring;

import com.jugg.agile.framework.core.util.JaValidateUtil;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.data.mongodb.core.MongoTemplate;

/**
 * MongoTemplate处理器
 *
 * @author chenjian
 * @since 2024年09月25日 17:41:20
 */
public class JaMongoTemplateProcessor {

    /**
     * 简单创建
     */
    public static MongoTemplate createSimple(String database, String uri) {
        JaValidateUtil.notNull(database, () -> "create MongoTemplate error : database is null");
        JaValidateUtil.notNull(uri, () -> "create MongoTemplate error : uri is null");
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder()
                .retryWrites(false)
                .applyConnectionString(new ConnectionString(uri))
                .build()
                , null);
        return new MongoTemplate(client, database);
    }

}
