package com.jugg.agile.middleware.mongodb.spring;

import com.jugg.agile.framework.core.util.JaValidateUtil;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import org.springframework.data.mongodb.core.MongoTemplate;

/**
 * MongoTemplate处理器
 *
 * @author chenjian
 * @since 2024年09月25日 17:41:20
 */
public class JaMongoTemplateProcessor {

    /**
     * 简单创建
     */
    public static MongoTemplate createSimple(String database, String uri) {
        JaValidateUtil.notNull(database, () -> "create MongoTemplate error : database is null");
        JaValidateUtil.notNull(uri, () -> "create MongoTemplate error : uri is null");
        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
        MongoClient client = new MongoClient(new MongoClientURI(uri, builder));
        return new MongoTemplate(client, database);
    }

}
