package com.jugg.agile.middleware.mongodb.dapper;

import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAopUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

@Component
@ConditionalOnClass(name = {JaNodeSpanMongoTemplate.ProxyClassName})
public class JaNodeSpanMongoTemplate implements JaNodeSpanResolver, JaDapperAspectPointcut {

    public static final String ProxyClassName = "org.springframework.data.mongodb.core.MongoTemplate";

    private static final NodeKind mongoTemplateNodeKind = new NodeKind("mongodb")
            .buildIdHandler(JaAopUtil::getSimpleName)
            .buildReqArgsHandler(args -> {
                if (JaCollectionUtil.isEmpty(args)) {
                    return args;
                }
                ArrayList<Object> objects = new ArrayList<>(args.length);
                for (Object arg : args) {
                    if (arg instanceof Query
                            || arg instanceof Class
                    ) {
                        continue;
                    }
                    objects.add(arg);
                }
                return objects.toArray();
            });

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        if (invocation instanceof ReflectiveMethodInvocation) {
            Object proxy = ((ReflectiveMethodInvocation) invocation).getProxy();
            if (proxy.toString().startsWith(ProxyClassName)) {
                return get(mongoTemplateNodeKind);
            }
        }
        return null;
    }

    @Override
    public String getExpression() {
        return "execution(* org.springframework.data.mongodb.core.MongoOperations.*(..))";
    }

}
