package com.jugg.agile.middleware.nacos.config;

import com.alibaba.nacos.api.PropertyKeyConst;
import com.jugg.agile.framework.core.config.JaPrePropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaSpringProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigJuggListener;

import java.util.Map;
import java.util.Properties;

public class JaNacosPropertyHandler implements JaPrePropertyHandler {
    @Override
    public void addAndCover() {
        String keyPrefix = "nacos_";
        String dataId = JaSpringProperty.getApplicationName() + "-application.yml";
        String serverAddr = System.getProperty(keyPrefix + PropertyKeyConst.SERVER_ADDR);
        if (JaStringUtil.isNotEmpty(serverAddr)) {
            Properties properties = new Properties();
            String namespace = System.getProperty(keyPrefix + PropertyKeyConst.NAMESPACE);
            String username = System.getProperty(keyPrefix + PropertyKeyConst.USERNAME);
            String password = System.getProperty(keyPrefix + PropertyKeyConst.PASSWORD);
            properties.put(PropertyKeyConst.SERVER_ADDR, serverAddr);
            properties.put(PropertyKeyConst.NAMESPACE, namespace);
            properties.put(PropertyKeyConst.USERNAME, username);
            properties.put(PropertyKeyConst.PASSWORD, password);
            JaNacosConfig.setProperties(properties);
        } else {
            JaNacosConfig.getProperties();
        }

        Map<String, Object> nacosMap = JaNacosConfig.readYaml(dataId, new JaNacosConfigJuggListener());
        if (JaCollectionUtil.isNotEmpty(nacosMap)) {
            JaProperty.getPropertyMap().putAll(nacosMap);
        }
    }
}
