package com.jugg.agile.middleware.nacos.config.meta;

import com.alibaba.nacos.api.common.Constants;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Properties;

@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class JaNacosConfigEntity {

    private String dataId;
    private String serverAddr;
    private String namespace;
    @Builder.Default
    private String group = Constants.DEFAULT_GROUP;
    @Builder.Default
    private long timeoutMs = 5000;
    private String username;
    private String password;
    private JaNacosConfigListener listener;
    @Builder.Default
    private boolean readStop = false;
    @Builder.Default
    private boolean printLog = true;
    /**
     * serverAddr
     * namespace
     * username
     * password
     * 自行构建上述值则无需再传递
     */
    private Properties properties;
}
