package com.jugg.agile.middleware.nacos.config.meta;

import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;

import java.util.Map;

public interface JaNacosConfigYamlListener extends JaNacosConfigListener {
    void receiveConfigInfo(Map<String, Object> configInfo);

    default void receiveConfigInfo(final String configInfo) {
        if (JaStringUtil.isNotEmpty(configInfo)) {
            try {
                Map<String, Object> flattenedMap = JaYamlProcessor.getFlattenedMap(configInfo);
                if (JaCollectionUtil.isNotEmpty(flattenedMap)) {
                    receiveConfigInfo(flattenedMap);
                }
            } catch (Throwable e) {
                JaLog.error("nacos config listener receiveConfigInfo error:[{configInfo}]", e);
            }
        }


    }
}
