package com.jugg.agile.middleware.nacos.config;

import com.alibaba.nacos.api.PropertyKeyConst;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaPropertiesProcessor;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigServerEntity;

import java.util.Properties;

/**
 * 配置中心处理器, 获取&缓存账号密码等相关配置
 *
 * @author chenjian
 * @since 2020年07月13日 12:05:52
 */
public class JaNacosConfigPropertiesProcessor {

    private JaNacosConfigPropertiesProcessor() {
    }

    /**
     * 地址 账号 密码全局缓存
     */
    private static JaNacosConfigServerEntity entity;

    /**
     * 创建 ConfigService 所需 Properties
     */
    public static Properties getServerAddrProperties() {
        if (null != entity) {
            return getServerAddrProperties(entity);
        }
        entity = new JaNacosConfigServerEntity();
        String serverAddr = get("ja.nacos.serverAddr");
        if (JaStringUtil.isSafeEmpty(serverAddr)) {
            Properties properties = JaPropertiesProcessor.readByResources(String.format("nacos/%s.properties", JaEnvProperty.getEnv()));
            assert properties != null;
            entity.setServerAddr(properties.get(PropertyKeyConst.SERVER_ADDR).toString());
            entity.setUsername(properties.get(PropertyKeyConst.USERNAME).toString());
            entity.setPassword(properties.get(PropertyKeyConst.PASSWORD).toString());
        } else {
            entity.setServerAddr(serverAddr);
            entity.setUsername(get("ja.nacos.username"));
            entity.setPassword(get("ja.nacos.password"));
        }
        return getServerAddrProperties(entity);
    }

    private static String get(String key) {
        String value = JaProperty.get(key);
        if (JaStringUtil.isEmpty(value)) {
            value = JaEnvProperty.get(key);
        }
        return value;
    }

    /**
     * 应用 namespace
     */
    public static String getNameSpaceApplication() {
        return get("ja.nacos.namespace.application");
    }

    /**
     * 公共 namespace
     */
    public static String getNameSpaceCommon() {
        return get("ja.nacos.namespace.common");
    }

    public static boolean isUser() {
        String isUser = get("ja.nacos.isUser");
        if (JaStringUtil.isNotEmpty(isUser)) {
            return Boolean.parseBoolean(isUser);
        }
        return true;
    }


    public static Properties getServerAddrProperties(JaNacosConfigServerEntity entity) {
        Properties properties = new Properties();
        properties.put(PropertyKeyConst.SERVER_ADDR, entity.getServerAddr());
        properties.put(PropertyKeyConst.USERNAME, entity.getUsername());
        properties.put(PropertyKeyConst.PASSWORD, entity.getPassword());
        return properties;
    }

}
