package com.jugg.agile.middleware.nacos.config;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPrePropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaSystemProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.nacos.config.listenter.JaNacosConfigDefaultListener;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigEntity;

import java.util.Map;

/**
 * 加载应用配置
 *
 * @author chenjian
 * @since 2024年06月14日 17:42:12
 */
public class JaNacosConfigPropertyHandler implements JaPrePropertyHandler {
    @Override
    public void addAndCover() {
        if (Boolean.TRUE.equals(JaProperty.getBoolean("ja.nacos.enabled", true))) {
            try {
                Map<String, Object> nacosMap = JaNacosConfigService.readYaml(JaNacosConfigEntity.builder()
                                .dataId(JaEnvProperty.getApplicationName() + "-application.yml")
                                .group(JaEnvProperty.getVersion())
                                .namespace(JaNacosConfigPropertiesProcessor.getNameSpaceApplication())
                                .listener(JaNacosConfigDefaultListener.DefaultListener)
                                .build()
                        , JaNacosConfigPropertiesProcessor.getServerAddrProperties());
                if (JaCollectionUtil.isNotEmpty(nacosMap)) {
                    JaProperty.getPropertyMap().putAll(nacosMap);
                }
            } catch (Throwable e) {
                JaLog.error("nacos read error", e);
            }


        }


    }

    public static void main(String[] args) {
        JaSystemProperty.setEnv("aliyun-paas");
        JaSystemProperty.setApplicationName("atmc");
        JaSystemProperty.setVersion("2.2.21");
        JaEnvProperty.set("ja.nacos.appNamespace", "f1271d47-fe9c-4938-abfa-2dbf2cf3c144");
        new JaNacosConfigPropertyHandler().addAndCover();

    }
}
