/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.nacos.config;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaPropertiesProcessor;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigServerEntity;
import java.util.Properties;

public class JaNacosConfigPropertiesProcessor {
    private static JaNacosConfigServerEntity entity;

    private JaNacosConfigPropertiesProcessor() {
    }

    public static Properties getServerAddrProperties() {
        if (null != entity) {
            return JaNacosConfigPropertiesProcessor.getServerAddrProperties(entity);
        }
        entity = new JaNacosConfigServerEntity();
        String serverAddr = JaNacosConfigPropertiesProcessor.get("ja.nacos.serverAddr");
        if (JaStringUtil.isSafeEmpty((String)serverAddr)) {
            Properties properties = JaPropertiesProcessor.readByResources((String)String.format("nacos/%s.properties", JaEnvProperty.getEnv()));
            assert (properties != null);
            entity.setServerAddr(properties.get("serverAddr").toString());
            entity.setUsername(properties.get("username").toString());
            entity.setPassword(properties.get("password").toString());
        } else {
            entity.setServerAddr(serverAddr);
            entity.setUsername(JaNacosConfigPropertiesProcessor.get("ja.nacos.username"));
            entity.setPassword(JaNacosConfigPropertiesProcessor.get("ja.nacos.password"));
        }
        return JaNacosConfigPropertiesProcessor.getServerAddrProperties(entity);
    }

    private static String get(String key) {
        String value = JaProperty.get((String)key);
        if (JaStringUtil.isEmpty((String)value)) {
            value = JaEnvProperty.get((String)key);
        }
        return value;
    }

    public static String getNameSpaceApplication() {
        return JaNacosConfigPropertiesProcessor.get("ja.nacos.namespace.application");
    }

    public static String getNameSpaceCommon() {
        return JaNacosConfigPropertiesProcessor.get("ja.nacos.namespace.common");
    }

    public static boolean isUser() {
        String isUser = JaNacosConfigPropertiesProcessor.get("ja.nacos.isUser");
        if (JaStringUtil.isNotEmpty((String)isUser)) {
            return Boolean.parseBoolean(isUser);
        }
        return true;
    }

    public static Properties getServerAddrProperties(JaNacosConfigServerEntity entity) {
        Properties properties = new Properties();
        properties.put("serverAddr", entity.getServerAddr());
        if (JaStringUtil.isSafeNotEmpty((String)entity.getUsername())) {
            properties.put("username", entity.getUsername());
        }
        if (JaStringUtil.isSafeNotEmpty((String)entity.getPassword())) {
            properties.put("password", entity.getPassword());
        }
        return properties;
    }
}

