package com.jugg.agile.middleware.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

/**
 * 应对一个服务注册多个服务名, 慎用, 建议使用starter原生功能
 * TODO 为实现 Watch subscribe unsubscribe
 *
 * @author chenjian
 * @since 2025年03月21日 21:08:00
 */
@Slf4j
public class JaNamingService {

    /**
     * 应对一个服务注册多个服务名, 慎用, 建议使用starter原生功能
     * spring.cloud.nacos.discovery.service
     * TODO 为实现 Watch subscribe unsubscribe
     */
    @SneakyThrows
    public static void registerInstancesByCurrentInstance() {
        NamingService namingService = getNamingServiceByNacosServiceManager();
        String services = JaProperty.get("ja.nacos.discovery.services");
        String[] serviceArray = services.split(",");
        for (String service : serviceArray) {
            registerInstance(namingService, JaNacosDiscoveryPropertiesProcessor.createByCurrent(service));
        }
    }


    /**
     * @see NacosServiceRegistry#register(org.springframework.cloud.client.serviceregistry.Registration)
     * @see NacosServiceRegistry#deregister(org.springframework.cloud.client.serviceregistry.Registration)
     */
    @SneakyThrows
    public static void registerInstance(NamingService namingService, NacosDiscoveryProperties nacosDiscoveryProperties) {
//        NamingService namingService = NamingFactory.createNamingService(nacosDiscoveryProperties.getNacosProperties());
        namingService.registerInstance(nacosDiscoveryProperties.getService()
                , nacosDiscoveryProperties.getGroup()
                , getNacosInstanceFromRegistration(nacosDiscoveryProperties));
        JaShutdownHookUtil.add("nacos namingService deregisterInstance:" + nacosDiscoveryProperties.getService(), () -> {
            try {
                namingService.deregisterInstance(nacosDiscoveryProperties.getService()
                        , nacosDiscoveryProperties.getGroup()
                        , nacosDiscoveryProperties.getIp()
                        , nacosDiscoveryProperties.getPort()
                        , nacosDiscoveryProperties.getClusterName());
            } catch (Throwable e) {
                log.error("ERR_NACOS_DEREGISTER, de-register failed...{},", nacosDiscoveryProperties.toString(), e);
            }
        });
    }

    /**
     * 通过 NacosServiceManager 获取 NamingService
     *
     * @see NacosServiceManager#getNamingService(java.util.Properties) 获取 NamingService
     */
    public static NamingService getNamingServiceByNacosServiceManager() {
        NacosServiceManager bean = JaSpringBeanUtil.getBean(NacosServiceManager.class);
        assert bean != null;
        return bean.getNamingService(null);
    }

    /**
     * @see NacosServiceRegistry#getNacosInstanceFromRegistration(org.springframework.cloud.client.serviceregistry.Registration)
     */
    private static Instance getNacosInstanceFromRegistration(NacosDiscoveryProperties nacosDiscoveryProperties) {
        Instance instance = new Instance();
        instance.setIp(nacosDiscoveryProperties.getIp());
        instance.setPort(nacosDiscoveryProperties.getPort());
        instance.setWeight(nacosDiscoveryProperties.getWeight());
        instance.setClusterName(nacosDiscoveryProperties.getClusterName());
        instance.setEnabled(nacosDiscoveryProperties.isInstanceEnabled());
        instance.setMetadata(nacosDiscoveryProperties.getMetadata());
        instance.setEphemeral(nacosDiscoveryProperties.isEphemeral());
        return instance;
    }
}
