package com.jugg.agile.middleware.nacos.config;

import com.alibaba.nacos.api.common.Constants;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaSystemProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.JaClassUtil;
import com.jugg.agile.framework.meta.constants.JaConfigKeyConstants;
import com.jugg.agile.middleware.nacos.config.listenter.JaNacosConfigDefaultListener;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigEntity;

import java.io.IOException;
import java.util.Map;

/**
 * 加载应用配置
 *
 * @author chenjian
 * @since 2024年06月14日 17:42:12
 */
public class JaNacosConfigPropertyHandler implements JaCenterPropertyHandler {

    public static final String KeyUseListener = "ja.nacos.useListener";

    @Override
    public void addAndCover() {
        try {
            System.setProperty("project.name", JaEnvProperty.getApplicationName());
            wrapCommon();
            wrapApplication();
            wrapDiscovery();
        } catch (Throwable e) {
            JaLog.error("JaNacosConfigPropertyHandler read error", e);
        }
    }

    private void wrapDiscovery() {
        if (JaClassUtil.hashClass("com.alibaba.nacos.api.naming.NamingService")) {
            // TODO 初始化entity 后续优化
            JaNacosConfigPropertiesProcessor.getServerAddrProperties();
            addAndCover("spring.cloud.nacos.server-addr", JaNacosConfigPropertiesProcessor.getEntity().getServerAddr());
            addAndCover("spring.cloud.nacos.username", JaNacosConfigPropertiesProcessor.getEntity().getUsername());
            addAndCover("spring.cloud.nacos.password", JaNacosConfigPropertiesProcessor.getEntity().getPassword());
        }
    }

    private void wrapCommon() {
        Map<String, Object> nacosMap = JaNacosConfigService.readYaml(JaNacosConfigEntity.builder()
                .dataId("jugg-application.yml")
                .group(Constants.DEFAULT_GROUP)
                .namespace(JaNacosConfigPropertiesProcessor.getNameSpaceCommon())
                .listener(Boolean.TRUE.equals(JaProperty.getBoolean(JaConfigKeyConstants.Nacos.UseListener, true)) ? JaNacosConfigDefaultListener.DefaultListener : null)
                .build());
        if (JaCollectionUtil.isNotEmpty(nacosMap)) {
            JaProperty.getPropertyMap().putAll(nacosMap);
        }
    }


    private void wrapApplication() {
        String version = JaEnvProperty.getVersion();
        if (JaStringUtil.isEmpty(version)) {
            version = Constants.DEFAULT_GROUP;
        }
        Map<String, Object> nacosMap = JaNacosConfigService.readYaml(JaNacosConfigEntity.builder()
                .dataId(JaEnvProperty.getApplicationName() + "-application.yml")
                .group(version)
                .namespace(JaNacosConfigPropertiesProcessor.getNameSpaceApplication())
                .listener(Boolean.TRUE.equals(JaProperty.getBoolean(JaConfigKeyConstants.Nacos.UseListener, true)) ? JaNacosConfigDefaultListener.DefaultListener : null)
                .build());
        if (JaCollectionUtil.isNotEmpty(nacosMap)) {
            JaProperty.getPropertyMap().putAll(nacosMap);
        }
    }

    public static void main(String[] args) throws IOException {
        JaSystemProperty.setEnv("aliyun-paas");
        JaSystemProperty.setApplicationName("atmc");
        JaSystemProperty.setVersion("2.2.21");

        JaProperty.getPropertyMap().put("ja.nacos.serverAddr", "http://121.37.176.231:8848/nacos");
        JaProperty.getPropertyMap().put("ja.nacos.username", "athena-nonfunc");
        JaProperty.getPropertyMap().put("ja.nacos.password", "athena");
        JaProperty.getPropertyMap().put("ja.nacos.namespace.application", "f1271d47-fe9c-4938-abfa-2dbf2cf3c144");
        JaProperty.getPropertyMap().put("ja.nacos.namespace.common", "f408c007-a82f-44df-9b2d-68a0f008bf61");

        JaProperty.getPropertyMap().put("ja.nacos.serverAddr", "http://121.37.176.231:8848");
        JaProperty.getPropertyMap().put("ja.nacos.username", "");
        JaProperty.getPropertyMap().put("ja.nacos.password", "");
        JaProperty.getPropertyMap().put("ja.nacos.namespace.application", "79fdd598-1313-4f81-97c8-548a1d72e280");
        JaProperty.getPropertyMap().put("ja.nacos.namespace.common", "f408c007-a82f-44df-9b2d-68a0f008bf61");


        new JaNacosConfigPropertyHandler().addAndCover();
        System.out.println(JaProperty.get("ja.alarm.webhook.default"));
        System.out.println(JaProperty.get("ja.alarm.webhook.throwable"));
        System.out.println(JaProperty.get("ja.alarm.webhook.notify.default"));

        System.in.read();
    }
}
