package com.jugg.agile.middleware.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.jugg.agile.framework.core.util.reflect.bean.copy.JaBeanCopy;

/**
 * 应对一个服务注册多个服务名, 慎用, 建议使用starter原生功能
 *
 * @author chenjian
 * @since 2025年03月21日 21:08:00
 */
public class JaNacosDiscoveryPropertiesProcessor {

    private JaNacosDiscoveryPropertiesProcessor() {
    }

    private static NacosDiscoveryProperties nacosDiscoveryProperties;

    public static NacosDiscoveryProperties getNacosDiscoveryProperties() {
        return nacosDiscoveryProperties;
    }

    public static void setNacosDiscoveryProperties(NacosDiscoveryProperties nacosDiscoveryProperties) {
        JaNacosDiscoveryPropertiesProcessor.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    /**
     * 基于当前已有配置创建一个新服务名配置
     * 适配一个服务注册多个服务名
     */
    public static NacosDiscoveryProperties createByCurrent(String service) {
        NacosDiscoveryProperties bean = getNacosDiscoveryProperties();
        if (null == bean) {
            return bean;
        }
        NacosDiscoveryProperties nacosDiscoveryProperties = JaBeanCopy.cpDeep(bean, NacosDiscoveryProperties.class);
        nacosDiscoveryProperties.setService(service);

        // TODO 是否需要修改
        // server_context_path -> /jugg
        // APPIMAGENAME=aam
        // management.endpoints.web.base-path=/aam/actuator
        return nacosDiscoveryProperties;
    }
}
