/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.nacos.discovery.JaNacosDiscoveryPropertiesProcessor;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaNamingService {
    private static final Logger log = LoggerFactory.getLogger(JaNamingService.class);

    private JaNamingService() {
    }

    public static void registerInstancesByCurrentInstance() {
        String services = JaProperty.get((String)"ja.nacos.discovery.services");
        if (JaStringUtil.isEmpty((String)services)) {
            return;
        }
        Object[] serviceArray = services.split(",");
        if (JaCollectionUtil.isEmpty((Object[])serviceArray)) {
            return;
        }
        NamingService namingService = JaNamingService.getNamingServiceByNacosServiceManager();
        if (null == namingService) {
            JaLog.warn((String)"ja.nacos.discovery.services : namingService is null", (Object[])new Object[0]);
            return;
        }
        for (Object service : serviceArray) {
            JaNamingService.registerInstance(namingService, JaNacosDiscoveryPropertiesProcessor.createByCurrent(((String)service).trim()));
        }
    }

    public static void registerInstance(NamingService namingService, NacosDiscoveryProperties nacosDiscoveryProperties) {
        namingService.registerInstance(nacosDiscoveryProperties.getService(), nacosDiscoveryProperties.getGroup(), JaNamingService.getNacosInstanceFromRegistration(nacosDiscoveryProperties));
        JaShutdownHookUtil.add((String)("nacos namingService deregisterInstance:" + nacosDiscoveryProperties.getService()), () -> {
            try {
                namingService.deregisterInstance(nacosDiscoveryProperties.getService(), nacosDiscoveryProperties.getGroup(), nacosDiscoveryProperties.getIp(), nacosDiscoveryProperties.getPort(), nacosDiscoveryProperties.getClusterName());
            }
            catch (Throwable e) {
                log.error("ERR_NACOS_DEREGISTER, de-register failed...{},", (Object)nacosDiscoveryProperties.toString(), (Object)e);
            }
        });
    }

    public static NamingService getNamingServiceByNacosServiceManager() {
        NacosServiceManager bean = (NacosServiceManager)JaSpringBeanUtil.getBean(NacosServiceManager.class);
        if (null == bean) {
            return null;
        }
        return bean.getNamingService(null);
    }

    public static void deregisterCurrentInstance() {
        NacosDiscoveryProperties nacosDiscoveryProperties = (NacosDiscoveryProperties)JaSpringBeanUtil.getBean(NacosDiscoveryProperties.class);
        assert (nacosDiscoveryProperties != null);
        JaShutdownHookUtil.add((String)("nacos namingService deregisterInstance:" + nacosDiscoveryProperties.getService()), () -> {
            try {
                Objects.requireNonNull(JaNamingService.getNamingServiceByNacosServiceManager()).deregisterInstance(nacosDiscoveryProperties.getService(), nacosDiscoveryProperties.getGroup(), nacosDiscoveryProperties.getIp(), nacosDiscoveryProperties.getPort(), nacosDiscoveryProperties.getClusterName());
            }
            catch (Throwable e) {
                JaLog.error((String)"ERR_NACOS_DEREGISTER, de-register failed...{},", (Object[])new Object[]{nacosDiscoveryProperties.toString(), e});
            }
        });
    }

    private static Instance getNacosInstanceFromRegistration(NacosDiscoveryProperties nacosDiscoveryProperties) {
        Instance instance = new Instance();
        instance.setIp(nacosDiscoveryProperties.getIp());
        instance.setPort(nacosDiscoveryProperties.getPort());
        instance.setWeight((double)nacosDiscoveryProperties.getWeight());
        instance.setClusterName(nacosDiscoveryProperties.getClusterName());
        instance.setEnabled(nacosDiscoveryProperties.isInstanceEnabled());
        instance.setMetadata(nacosDiscoveryProperties.getMetadata());
        instance.setEphemeral(nacosDiscoveryProperties.isEphemeral());
        return instance;
    }
}

