package com.jugg.agile.middleware.nacos.discovery;

import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigServerEntity;

import java.util.Arrays;
import java.util.List;

public class TestNamingFactory {

    public static void main(String[] args) throws Throwable {
        JaNacosConfigServerEntity build = JaNacosConfigServerEntity.builder()
                .serverAddr("https://nacos-paas.digiwincloud.com.cn")
                .username("athena-nonfunc")
                .password("athena")
                .build();
        NamingService namingService = NamingFactory.createNamingService(JaNacosDiscoveryPropertiesProcessor.createByCurrent("jugg").getNacosProperties());


        EventListener eventListener = event -> new EventListener() {
            @Override
            public void onEvent(Event event) {
                if (event instanceof NamingEvent) {
                    List<Instance> instances = ((NamingEvent) event).getInstances();

                    System.out.println();

//                    Optional<Instance> instanceOptional = selectCurrentInstance(instances);
//                    instanceOptional.ifPresent(currentInstance -> {resetIfNeeded(currentInstance);
//                    });
                }
            }
        };


        namingService.subscribe("jugg", "DEFAULT_GROUP",
                Arrays.asList("DEFAULT"), eventListener);
    }

//    private static Optional<Instance> selectCurrentInstance(List<Instance> instances) {
//        return instances.stream()
//                .filter(instance -> properties.getIp().equals(instance.getIp())
//                        && properties.getPort() == instance.getPort())
//                .findFirst();
//    }
//
//    private static void resetIfNeeded(Instance instance) {
//        if (!properties.getMetadata().equals(instance.getMetadata())) {
//            properties.setMetadata(instance.getMetadata());
//        }
//    }
}
