/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.nacos.config;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigServerEntity;
import java.util.Properties;

public class JaNacosConfigPropertiesProcessor {
    private static JaNacosConfigServerEntity entity;

    private JaNacosConfigPropertiesProcessor() {
    }

    public static Properties getServerAddrProperties() {
        if (null != entity) {
            return JaNacosConfigPropertiesProcessor.getServerAddrProperties(entity);
        }
        entity = new JaNacosConfigServerEntity();
        entity.setServerAddr(JaProperty.get((String)"ja.nacos.serverAddr"));
        entity.setUsername(JaProperty.get((String)"ja.nacos.username"));
        entity.setPassword(JaProperty.get((String)"ja.nacos.password"));
        return JaNacosConfigPropertiesProcessor.getServerAddrProperties(entity);
    }

    public static String getNameSpaceApplication() {
        return JaProperty.get((String)"ja.nacos.namespace.application");
    }

    public static String getNameSpaceCommon() {
        return JaProperty.get((String)"ja.nacos.namespace.common");
    }

    public static boolean isUser() {
        String isUser = JaProperty.get((String)"ja.nacos.isUser");
        if (JaStringUtil.isNotEmpty((String)isUser)) {
            return Boolean.parseBoolean(isUser);
        }
        return true;
    }

    public static Properties getServerAddrProperties(JaNacosConfigServerEntity entity) {
        Properties properties = new Properties();
        properties.put("serverAddr", entity.getServerAddr());
        if (JaStringUtil.isSafeNotEmpty((String)entity.getUsername())) {
            properties.put("username", entity.getUsername());
        }
        if (JaStringUtil.isSafeNotEmpty((String)entity.getPassword())) {
            properties.put("password", entity.getPassword());
        }
        return properties;
    }
}

