/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.nacos.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import com.jugg.agile.framework.core.dapper.log.JaDapperLog;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.JaThrowableUtil;
import com.jugg.agile.framework.core.util.JaValidateUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.JaClassUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.listenter.JaNacosConfigListener;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigEntity;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigServerEntity;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JaNacosConfigService {
    public static String read(JaNacosConfigEntity entity, Properties properties) {
        if (!JaNacosConfigPropertiesProcessor.isUser()) {
            return null;
        }
        String dataId = entity.getDataId();
        JaValidateUtil.notNull((String)dataId, () -> "read nacos dataId is null");
        String group = entity.getGroup();
        JaValidateUtil.notNull((String)group, () -> "read nacos group is null");
        String namespace = entity.getNamespace();
        JaValidateUtil.notNull((String)namespace, () -> "read nacos namespace is null");
        JaValidateUtil.notNull((Map)properties, () -> "read nacos properties is null");
        properties.put("namespace", namespace);
        ConfigService configService = NacosFactory.createConfigService((Properties)properties);
        String content = configService.getConfig(dataId, entity.getGroup(), entity.getTimeoutMs());
        if (null != entity.getListener()) {
            configService.addListener(dataId, entity.getGroup(), (Listener)entity.getListener());
            JaShutdownHookUtil.add((String)dataId, () -> JaThrowableUtil.tryCatchRun(() -> ((ConfigService)configService).shutDown()));
        } else {
            configService.shutDown();
        }
        JaLog.info((String)"{} {} nacos config : \n{}", (Object[])new Object[]{dataId, group, content});
        return content;
    }

    public static String read(JaNacosConfigEntity entity, JaNacosConfigServerEntity serverEntity) {
        return JaNacosConfigService.read(entity, JaNacosConfigPropertiesProcessor.getServerAddrProperties(serverEntity));
    }

    public static Map<String, Object> readYaml(JaNacosConfigEntity entity, Properties properties) {
        String content = JaNacosConfigService.read(entity, properties);
        return JaStringUtil.isEmpty((String)content) ? new HashMap(0) : JaYamlProcessor.getFlattenedMap((String)content);
    }

    public static Map<String, Object> readYaml(JaNacosConfigEntity entity, JaNacosConfigServerEntity serverEntity) {
        return JaNacosConfigService.readYaml(entity, JaNacosConfigPropertiesProcessor.getServerAddrProperties(serverEntity));
    }

    public static Map<String, Object> readYaml(JaNacosConfigEntity entity) {
        Properties serverAddrProperties;
        try {
            serverAddrProperties = JaNacosConfigPropertiesProcessor.getServerAddrProperties();
        }
        catch (NullPointerException e) {
            JaLog.warn((String)"{} nacos readYaml error, serverAddrProperties is null", (Object[])new Object[]{entity.getDataId()});
            return null;
        }
        return JaNacosConfigService.readYaml(entity, serverAddrProperties);
    }

    public static Map<String, Object> readYaml(String dataId, String namespace, JaNacosConfigListener listener) {
        return JaNacosConfigService.readYaml(JaNacosConfigEntity.builder().dataId(dataId).namespace(namespace).group(JaEnvProperty.getVersion()).listener(listener).build());
    }

    public static Map<String, Object> readYaml(String dataId, String namespace) {
        return JaNacosConfigService.readYaml(dataId, namespace, null);
    }

    public static void loadYaml(String dataId, String namespace) {
        Map<String, Object> nacosMap = JaNacosConfigService.readYaml(dataId, namespace, null);
        if (JaCollectionUtil.isNotEmpty(nacosMap)) {
            JaProperty.getPropertyMap().putAll(nacosMap);
        }
    }

    public static void main(String[] args) throws IOException {
        JaNacosConfigListener jaNacosConfigListener = new JaNacosConfigListener(){

            public void receiveConfigInfo(String configInfo) {
                System.out.println("configInfo : " + configInfo);
            }
        };
        Map<String, Object> read = JaNacosConfigService.readYaml(JaNacosConfigEntity.builder().namespace("8231cc09-273b-43db-8561-6a82f21f15e0").dataId("rabbitmq.yml").group("2.2.21").listener(jaNacosConfigListener).build(), ((JaNacosConfigServerEntity.JaNacosConfigServerEntityBuilder)((JaNacosConfigServerEntity.JaNacosConfigServerEntityBuilder)((JaNacosConfigServerEntity.JaNacosConfigServerEntityBuilder)JaNacosConfigServerEntity.builder().serverAddr("http://121.37.176.231:8848")).username("")).password("")).build());
        System.out.println(read);
        System.in.read();
    }

    static {
        if (JaClassUtil.hashClass((String)"ch.qos.logback.classic.LoggerContext") && JaDapperLog.getUseLogback()) {
            System.setProperty("nacos.logging.config", "classpath:jugg-nacos-logback.xml");
        }
    }
}

