/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.nacos.config;

import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaSystemProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.JaClassUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;
import com.jugg.agile.middleware.nacos.config.listenter.JaNacosConfigDefaultListener;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigEntity;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class JaNacosConfigPropertyHandler
implements JaCenterPropertyHandler {
    public static final String KeyUseListener = "ja.nacos.useListener";

    public void addAndCover() {
        try {
            System.setProperty("project.name", JaEnvProperty.getApplicationName());
            this.wrapCommon();
            this.wrapApplication();
            this.wrapDiscovery();
        }
        catch (Throwable e) {
            JaLog.error((String)"JaNacosConfigPropertyHandler read error", (Object[])new Object[]{e});
        }
    }

    private void wrapDiscovery() {
        Properties serverAddrProperties;
        if (JaClassUtil.hashClass((String)"com.alibaba.nacos.api.naming.NamingService") && null != (serverAddrProperties = JaNacosConfigPropertiesProcessor.getServerAddrProperties())) {
            this.addAndCover("spring.cloud.nacos.server-addr", JaNacosConfigPropertiesProcessor.getEntity().getServerAddr());
            this.addAndCover("spring.cloud.nacos.username", JaNacosConfigPropertiesProcessor.getEntity().getUsername());
            this.addAndCover("spring.cloud.nacos.password", JaNacosConfigPropertiesProcessor.getEntity().getPassword());
        }
    }

    private void wrapCommon() {
        Map<String, Object> nacosMap = JaNacosConfigService.readYaml(JaNacosConfigEntity.builder().dataId("jugg-application.yml").group("DEFAULT_GROUP").namespace(JaNacosConfigPropertiesProcessor.getNameSpaceCommon()).listener(Boolean.TRUE.equals(JaProperty.getBoolean((String)KeyUseListener, (Boolean)true)) ? JaNacosConfigDefaultListener.DefaultListener : null).build());
        if (JaCollectionUtil.isNotEmpty(nacosMap)) {
            JaProperty.getPropertyMap().putAll(nacosMap);
        }
    }

    private void wrapApplication() {
        Map<String, Object> nacosMap;
        String version = JaEnvProperty.getVersion();
        if (JaStringUtil.isEmpty((String)version)) {
            version = "DEFAULT_GROUP";
        }
        if (JaCollectionUtil.isNotEmpty(nacosMap = JaNacosConfigService.readYaml(JaNacosConfigEntity.builder().dataId(JaEnvProperty.getApplicationName() + "-application.yml").group(version).namespace(JaNacosConfigPropertiesProcessor.getNameSpaceApplication()).listener(Boolean.TRUE.equals(JaProperty.getBoolean((String)KeyUseListener, (Boolean)true)) ? JaNacosConfigDefaultListener.DefaultListener : null).build()))) {
            JaProperty.getPropertyMap().putAll(nacosMap);
        }
    }

    public static void main(String[] args) throws IOException {
        JaSystemProperty.setEnv((String)"aliyun-paas");
        JaSystemProperty.setApplicationName((String)"atmc");
        JaSystemProperty.setVersion((String)"2.2.21");
        JaProperty.getPropertyMap().put("ja.nacos.serverAddr", "http://121.37.176.231:8848/nacos");
        JaProperty.getPropertyMap().put("ja.nacos.username", "athena-nonfunc");
        JaProperty.getPropertyMap().put("ja.nacos.password", "athena");
        JaProperty.getPropertyMap().put("ja.nacos.namespace.application", "f1271d47-fe9c-4938-abfa-2dbf2cf3c144");
        JaProperty.getPropertyMap().put("ja.nacos.namespace.common", "f408c007-a82f-44df-9b2d-68a0f008bf61");
        JaProperty.getPropertyMap().put("ja.nacos.serverAddr", "http://121.37.176.231:8848");
        JaProperty.getPropertyMap().put("ja.nacos.username", "");
        JaProperty.getPropertyMap().put("ja.nacos.password", "");
        JaProperty.getPropertyMap().put("ja.nacos.namespace.application", "79fdd598-1313-4f81-97c8-548a1d72e280");
        JaProperty.getPropertyMap().put("ja.nacos.namespace.common", "f408c007-a82f-44df-9b2d-68a0f008bf61");
        new JaNacosConfigPropertyHandler().addAndCover();
        System.out.println(JaProperty.get((String)"ja.alarm.webhook.default"));
        System.out.println(JaProperty.get((String)"ja.alarm.webhook.throwable"));
        System.out.println(JaProperty.get((String)"ja.alarm.webhook.notify.default"));
        System.in.read();
    }
}

