package com.jugg.agile.middleware.nacos.config;

import com.alibaba.nacos.api.PropertyKeyConst;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.meta.JaNacosConfigServerEntity;

import java.util.Properties;

/**
 * 配置中心处理器, 获取&缓存账号密码等相关配置
 *
 * @author chenjian
 * @since 2020年07月13日 12:05:52
 */
public class JaNacosConfigPropertiesProcessor {

    private JaNacosConfigPropertiesProcessor() {
    }

    /**
     * 地址 账号 密码全局缓存
     */
    private static JaNacosConfigServerEntity entity;

    public static JaNacosConfigServerEntity getEntity() {
        return entity;
    }

    /**
     * 创建 ConfigService 所需 Properties
     */
    public static Properties getServerAddrProperties() {
        if (null != entity) {
            return getServerAddrProperties(entity);
        }
        entity = new JaNacosConfigServerEntity();
        entity.setServerAddr(JaProperty.get("ja.nacos.serverAddr"));
        entity.setUsername(JaProperty.get("ja.nacos.username"));
        entity.setPassword(JaProperty.get("ja.nacos.password"));
        return getServerAddrProperties(entity);
    }

    /**
     * 应用 namespace
     */
    public static String getNameSpaceApplication() {
        return JaProperty.get("ja.nacos.namespace.application");
    }

    /**
     * 公共 namespace
     */
    public static String getNameSpaceCommon() {
        return JaProperty.get("ja.nacos.namespace.common");
    }

    /**
     * 读取nacos
     */
    public static boolean isUser() {
        String isUser = JaProperty.get("ja.nacos.isUser");
        if (JaStringUtil.isNotEmpty(isUser)) {
            return Boolean.parseBoolean(isUser);
        }
        return true;
    }


    public static Properties getServerAddrProperties(JaNacosConfigServerEntity entity) {
        Properties properties = new Properties();
        if(JaStringUtil.isEmpty(entity.getServerAddr())){
           return null;
        }
        properties.put(PropertyKeyConst.SERVER_ADDR, entity.getServerAddr());
        if (JaStringUtil.isSafeNotEmpty(entity.getUsername())) {
            properties.put(PropertyKeyConst.USERNAME, entity.getUsername());
        }
        if (JaStringUtil.isSafeNotEmpty(entity.getPassword())) {
            properties.put(PropertyKeyConst.PASSWORD, entity.getPassword());
        }
        return properties;
    }

}
