package com.jugg.agile.middleware.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

/**
 * 应对一个服务注册多个服务名, 慎用, 建议使用starter原生功能
 * TODO 未实现 Watch subscribe unsubscribe
 *
 * @author chenjian
 * @since 2025年03月21日 21:08:00
 */
@Slf4j
public class JaNamingService {
    private JaNamingService() {
    }

    /**
     * 应对一个服务注册多个服务名, 慎用, 建议使用starter原生功能
     * spring.cloud.nacos.discovery.service
     * TODO 未实现 Watch subscribe unsubscribe
     */
    @SneakyThrows
    public static void registerInstancesByCurrentInstance() {
        String services = JaProperty.get("ja.nacos.discovery.services");
        if (JaStringUtil.isEmpty(services)) {
            return;
        }
        String[] serviceArray = services.split(",");
        if (JaCollectionUtil.isEmpty(serviceArray)) {
            return;
        }
        NamingService namingService = getNamingServiceByNacosServiceManager();
        if (null == namingService) {
            JaLog.warn("ja.nacos.discovery.services : namingService is null");
            return;
        }
        for (String service : serviceArray) {
            registerInstance(namingService, JaNacosDiscoveryPropertiesProcessor.createByCurrent(service.trim()));
        }
    }


    /**
     * @see NacosServiceRegistry#register(org.springframework.cloud.client.serviceregistry.Registration)
     * @see NacosServiceRegistry#deregister(org.springframework.cloud.client.serviceregistry.Registration)
     */
    @SneakyThrows
    public static void registerInstance(NamingService namingService, NacosDiscoveryProperties nacosDiscoveryProperties) {
//        NamingService namingService = NamingFactory.createNamingService(nacosDiscoveryProperties.getNacosProperties());
        namingService.registerInstance(nacosDiscoveryProperties.getService()
                , nacosDiscoveryProperties.getGroup()
                , getNacosInstanceFromRegistration(nacosDiscoveryProperties));
        JaShutdownHookUtil.add("nacos namingService deregisterInstance:" + nacosDiscoveryProperties.getService(), () -> {
            try {
                namingService.deregisterInstance(nacosDiscoveryProperties.getService()
                        , nacosDiscoveryProperties.getGroup()
                        , nacosDiscoveryProperties.getIp()
                        , nacosDiscoveryProperties.getPort()
                        , nacosDiscoveryProperties.getClusterName());
            } catch (Throwable e) {
                log.error("ERR_NACOS_DEREGISTER, de-register failed...{},", nacosDiscoveryProperties.toString(), e);
            }
        });
    }

    /**
     * 通过 NacosServiceManager 获取 NamingService
     *
     * @see NacosServiceManager#getNamingService(java.util.Properties) 获取 NamingService
     */
    public static NamingService getNamingServiceByNacosServiceManager() {
        NacosServiceManager bean = JaSpringBeanUtil.getBean(NacosServiceManager.class);
        if (null == bean) {
            return null;
        }
        return bean.getNamingService(null);
    }

    public static void deregisterCurrentInstance(){
        NacosDiscoveryProperties nacosDiscoveryProperties = JaSpringBeanUtil.getBean(NacosDiscoveryProperties.class);
        assert nacosDiscoveryProperties != null;
        JaShutdownHookUtil.add("nacos namingService deregisterInstance:" + nacosDiscoveryProperties.getService(), () -> {
            try {
                Objects.requireNonNull(JaNamingService.getNamingServiceByNacosServiceManager()).deregisterInstance(nacosDiscoveryProperties.getService()
                        , nacosDiscoveryProperties.getGroup()
                        , nacosDiscoveryProperties.getIp()
                        , nacosDiscoveryProperties.getPort()
                        , nacosDiscoveryProperties.getClusterName());
            } catch (Throwable e) {
                JaLog.error("ERR_NACOS_DEREGISTER, de-register failed...{},", nacosDiscoveryProperties.toString(), e);
            }
        });
    }

    /**
     * @see NacosServiceRegistry#getNacosInstanceFromRegistration(org.springframework.cloud.client.serviceregistry.Registration)
     */
    private static Instance getNacosInstanceFromRegistration(NacosDiscoveryProperties nacosDiscoveryProperties) {
        Instance instance = new Instance();
        instance.setIp(nacosDiscoveryProperties.getIp());
        instance.setPort(nacosDiscoveryProperties.getPort());
        instance.setWeight(nacosDiscoveryProperties.getWeight());
        instance.setClusterName(nacosDiscoveryProperties.getClusterName());
        instance.setEnabled(nacosDiscoveryProperties.isInstanceEnabled());
        instance.setMetadata(nacosDiscoveryProperties.getMetadata());
        instance.setEphemeral(nacosDiscoveryProperties.isEphemeral());
        return instance;
    }
}
