package com.jugg.agile.middleware.nacos.discovery;

import com.jugg.agile.framework.core.util.reflect.clazz.JaClassUtil;
import com.jugg.agile.spring.boot.util.JaSpringBootUtil;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class JaNacosDiscoverySpringApplicationRunListener implements SpringApplicationRunListener, Ordered {

    public JaNacosDiscoverySpringApplicationRunListener(SpringApplication springApplication, String[] args) {
    }

    public void starting() {
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void started(ConfigurableApplicationContext context) {
        if (!JaSpringBootUtil.isCloudContainer()) {
            if (JaClassUtil.hashClass("com.alibaba.nacos.api.naming.NamingService")) {
                JaNamingService.registerInstancesByCurrentInstance();

            }
        }
    }

    @Override
    public void running(ConfigurableApplicationContext context) {
        if (!JaSpringBootUtil.isCloudContainer()) {
        }
    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }


    @Override
    public int getOrder() {
        return -5;
    }
}