/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.rabbitmq.spring;

import com.jugg.agile.framework.core.context.JaMapContextChain;
import com.jugg.agile.framework.core.context.biz.JaCoreContext;
import com.jugg.agile.framework.core.dapper.JaDapper;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAspectUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.core.util.datastructure.JaMapUtil;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import com.jugg.agile.framework.core.util.reflect.JaReflectUtil;
import com.jugg.agile.framework.core.util.unsafe.JaUnsafe;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.lang.reflect.Field;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;

@Order(value=10)
@Configuration
@ConditionalOnClass(name={"org.springframework.amqp.rabbit.annotation.EnableRabbit"})
public class JaNodeSpanRabbitListenerConsumer
implements ApplicationListener<ContextRefreshedEvent> {
    private static final ThreadLocal<Message> messageThreadLocal = new ThreadLocal();

    public void onApplicationEvent(@Nullable ContextRefreshedEvent event) {
        Map listenerContainers;
        RabbitListenerEndpointRegistry bean = (RabbitListenerEndpointRegistry)JaSpringBeanUtil.getBean(RabbitListenerEndpointRegistry.class);
        if (null != bean && JaCollectionUtil.isNotEmpty((Map)(listenerContainers = (Map)JaReflectUtil.getFieldValue((Object)bean, (String)"listenerContainers")))) {
            JaMessagingMessageListenerAdapterInterceptor methodInterceptor = new JaMessagingMessageListenerAdapterInterceptor();
            listenerContainers.forEach((k, v) -> {
                if (v instanceof SimpleMessageListenerContainer) {
                    Object messageListener = ((SimpleMessageListenerContainer)v).getMessageListener();
                    Object messageListenerProxy = JaSpringAopUtil.getProxy((Object)messageListener, (MethodInterceptor)methodInterceptor);
                    Field messageListenerField = JaReflectUtil.getField(AbstractMessageListenerContainer.class, (String)"messageListener");
                    JaUnsafe.setObjectFieldValue((Object)v, (Object)messageListenerProxy, (Field)messageListenerField);
                }
            });
        }
    }

    @Bean
    public JaRabbitListenerAspect jaRabbitListenerAspect() {
        return new JaRabbitListenerAspect();
    }

    @Aspect
    static class JaRabbitListenerAspect {
        private static final NodeKind rabbitMQConsume = new NodeKind("rabbitmq-consume", true);
        private static final String logFormatEntry = "queue:{},context:{}";

        public JaRabbitListenerAspect() {
            JaMapContextChain instance = JaMapContextChain.getInstance();
            JaLog.info((String)"JaRabbitListenerAspect init:{}", (Object[])new Object[]{instance});
        }

        @Pointcut(value="@annotation(org.springframework.amqp.rabbit.annotation.RabbitListener)")
        public void pointcut() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Around(value="pointcut()")
        public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
            Message message = (Message)messageThreadLocal.get();
            if (null == message) {
                JaLog.warn((String)"rabbitmq consumer not fount dapper node:{}", (Object[])new Object[]{JaAspectUtil.getFullName((ProceedingJoinPoint)pjp)});
                return pjp.proceed();
            }
            try {
                MessageProperties messageProperties = message.getMessageProperties();
                JaMapContextChain.getInstance().inherit((Object)JaMapUtil.convertToString((Map)messageProperties.getHeaders()));
                NodeSpan nodeSpan = NodeSpan.builder().id(JaAspectUtil.getSimpleName((ProceedingJoinPoint)pjp)).nodeKind(rabbitMQConsume).build();
                JaLog.info((String)logFormatEntry, (Object[])new Object[]{messageProperties.getConsumerQueue(), JaJson.toString((Object)JaCoreContext.getInstance().get())});
                Object object = JaDapper.dapperAspect((NodeSpan)nodeSpan, (Object[])new Object[]{message.getBody()}, (ProceedingJoinPoint)pjp);
                return object;
            }
            finally {
                JaMapContextChain.getInstance().remove();
            }
        }
    }

    static class JaMessagingMessageListenerAdapterInterceptor
    implements MethodInterceptor {
        private static final String onMessageMethodName = "onMessage";

        JaMessagingMessageListenerAdapterInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().getName().equals(onMessageMethodName)) {
                try {
                    messageThreadLocal.set((Message)invocation.getArguments()[0]);
                    Object object = invocation.proceed();
                    return object;
                }
                finally {
                    messageThreadLocal.remove();
                }
            }
            return invocation.proceed();
        }
    }
}

