/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.rabbitmq.spring;

import com.jugg.agile.framework.core.context.JaMapContextChain;
import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAopUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.rabbitmq.client.Channel;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(name={"org.springframework.amqp.rabbit.core.RabbitTemplate"})
public class JaNodeSpanRabbitTemplateProducer
implements JaNodeSpanResolver,
JaDapperAspectPointcut,
MessagePostProcessor {
    public static final String ProxyClassName = "org.springframework.amqp.rabbit.core.RabbitTemplate";
    private static final Set<String> sendMethodNameSet = new HashSet<String>(){
        {
            this.add("sendAndReceive");
            this.add("convertSendAndReceive");
            this.add("doSend");
            this.add("correlationConvertAndSend");
            this.add("send");
            this.add("convertAndSend");
            this.add("convertSendAndReceiveAsType");
        }
    };
    private static final NodeKind rabbitTemplateNodeKind = new NodeKind("rabbitmq-produce").buildIdHandler(JaAopUtil::getSimpleName).buildResponseHandler(o -> o instanceof Message ? null : o).buildReqArgsHandler(args -> {
        if (JaCollectionUtil.isEmpty((Object[])args)) {
            return args;
        }
        ArrayList<Object> objects = new ArrayList<Object>(((Object[])args).length);
        for (Object arg : args) {
            if (arg instanceof Channel || arg instanceof CorrelationData || arg instanceof Type || arg instanceof ParameterizedTypeReference) continue;
            if (arg instanceof Message) {
                objects.add(((Message)arg).getBody());
                continue;
            }
            objects.add(arg);
        }
        return objects.toArray();
    }).buildRequestIdThreadLocal();

    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        Object proxy;
        if (invocation instanceof ReflectiveMethodInvocation && (proxy = ((ReflectiveMethodInvocation)invocation).getProxy()).toString().startsWith(ProxyClassName) && sendMethodNameSet.contains(invocation.getMethod().getName())) {
            return this.get(rabbitTemplateNodeKind);
        }
        return null;
    }

    public String getExpression() {
        return "execution(* org.springframework.amqp.rabbit.core.RabbitTemplate.*(..))";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message postProcessMessage(Message message) throws AmqpException {
        try {
            Map headers = message.getMessageProperties().getHeaders();
            JaMapContextChain.getInstance().transmit().forEach(headers::put);
            headers.put(JaMDC.RequestId, rabbitTemplateNodeKind.getRequestIdThreadLocal().get());
            Message message2 = message;
            return message2;
        }
        finally {
            rabbitTemplateNodeKind.getRequestIdThreadLocal().remove();
        }
    }
}

