/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.rabbitmq.test.fanout;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.middleware.rabbitmq.test.TestConnectionFactory;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class JaRabbitMQConsumerTestFanout {
    public static void consumer(String connectionName) {
        ConnectionFactory factory = TestConnectionFactory.get();
        Connection connection = factory.newConnection(connectionName);
        final Channel channel = connection.createChannel();
        channel.exchangeDeclare("exchange_fanout_test", BuiltinExchangeType.FANOUT);
        String queueName = channel.queueDeclare().getQueue();
        JaLog.info((String)"queueName : {}", (Object[])new Object[]{queueName});
        channel.queueBind(queueName, "exchange_fanout_test", "");
        DefaultConsumer consumer = new DefaultConsumer(channel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                JaLog.info((String)"body:{}, consumerTag:{}, envelope:{}, properties:{}", (Object[])new Object[]{new String(body), consumerTag, envelope, properties});
                JaLog.info((String)"body : {}", (Object[])new Object[]{new String(body)});
                Thread.sleep(10000L);
                channel.basicAck(envelope.getDeliveryTag(), false);
            }
        };
        channel.basicConsume(queueName, false, (Consumer)consumer);
        JaShutdownHookUtil.add((String)connectionName, () -> {
            try {
                channel.close();
                connection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        });
    }

    public static void main(String[] args) {
        JaRabbitMQConsumerTestFanout.consumer("exchange_fanout_test_1");
    }
}

