package com.jugg.agile.middleware.rabbitmq.test;

import com.jugg.agile.framework.core.util.io.JaInputStreamUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.loader.JaAppClassLoader;
import com.rabbitmq.client.ConnectionFactory;
import lombok.SneakyThrows;

import java.io.InputStream;

public class TestConnectionFactory {

    public static ConnectionFactory get() {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost("mq-paas.digiwincloud.com.cn");
        factory.setUsername("digiwin");
        factory.setPassword("digiwin");
        factory.setVirtualHost("athena");
        factory.setPort(5677);
        return factory;
    }

    @SneakyThrows
    public static void testCompile() {
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream("sourceCode/MessagingMessageListenerAdapter.class")) {
            assert inputStream != null;
            JaAppClassLoader.defineClass("org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter"
                    , JaInputStreamUtil.read3(inputStream));
        }
    }

    public static void main(String[] args) {
        testCompile();
    }
}
