package com.jugg.agile.middleware.rabbitmq.config;

import com.jugg.agile.framework.core.config.JaPrePropertyHandler;
import com.jugg.agile.framework.core.util.reflect.clazz.JaClassUtil;

public class JaRabbitMQPropertyHandler implements JaPrePropertyHandler {
    @Override
    public void addAndCover() {
        if (JaClassUtil.hashClass("com.jugg.agile.middleware.nacos.config.JaNacosConfigService")) {
            JaRabbitMQNacosProcessor.addAndCover();
        }

        /*
         * org.springframework.boot.autoconfigure.amqp.RabbitProperties
         */
        // 开启发送确认
        addAndCover("spring.rabbitmq.publisherConfirms", true);
        // 开启发送失败退回
        addAndCover("spring.rabbitmq.publisherReturns", true);
        addAndCover("spring.rabbitmq.template.mandatory", true);
        addAndCover("spring.rabbitmq.listener.type", "simple");
        // 开启消息消费手动确认
        addAndCover("spring.rabbitmq.listener.simple.acknowledgeMode", "manual");
        addAndCover("spring.rabbitmq.listener.simple.prefetch", 3);
    }

    @Override
    public int order() {
        return 10;
    }
}
