package com.jugg.agile.middleware.rabbitmq.context;

import com.jugg.agile.framework.core.context.JaMapContextLink;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.util.JaStringUtil;

import java.util.Map;

/**
 * 兼容
 *
 * @author chenjian
 * @since 2024年06月04日 19:27:44
 */
public class PinpointSourceContextLink implements JaMapContextLink<JaCoreContextEntity> {

    public static final String PinpointPAppNameKey = "Pinpoint-pAppName";

    @Override
    public void inherit(Map<String, String> source, JaCoreContextEntity target) {
        if (null == target.getUsName()) {
            String usName = source.get(PinpointPAppNameKey);
            if (JaStringUtil.isSafeNotEmpty(usName)) {
                target.setUsName(usName);
            }
        }
    }

    @Override
    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        // Do nothing
    }
}
