package com.jugg.agile.middleware.rabbitmq.config;

import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.io.JaInputStreamUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.JaClassUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.loader.JaAppClassLoader;

import java.io.InputStream;

public class JaRabbitMQPropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        /*
         * org.springframework.boot.autoconfigure.amqp.RabbitProperties
         */
        // 开启发送确认
        addAndCover("spring.rabbitmq.publisherConfirms", true);
        // 开启发送失败退回
        addAndCover("spring.rabbitmq.publisherReturns", true);
        addAndCover("spring.rabbitmq.template.mandatory", true);
        addAndCover("spring.rabbitmq.listener.type", "simple");
        // 开启消息消费手动确认
        addAndCover("spring.rabbitmq.listener.simple.acknowledgeMode", "manual");
        addAndCover("spring.rabbitmq.listener.simple.prefetch", 3);

        if (JaClassUtil.hashClass("com.jugg.agile.middleware.nacos.config.JaNacosConfigService")) {
            JaRabbitMQNacosProcessor.addAndCover();
        }

        defineClass();
    }

    private static void defineClass() {
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream("sourceCode/MessagingMessageListenerAdapter.class")) {
            assert inputStream != null;
            JaAppClassLoader.defineClass("org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter"
                    , JaInputStreamUtil.read3(inputStream));
        } catch (Throwable e) {
            JaLog.error("sourceCode/MessagingMessageListenerAdapter.class defineClass error:{}", e.getMessage());
        }
    }

    @Override
    public int order() {
        return -10;
    }
}
