package com.jugg.agile.middleware.rabbitmq.context;

import com.jugg.agile.framework.core.context.JaMapContextLink;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.util.JaStringUtil;

import java.util.Map;

/**
 * 兼容
 *
 * @author chenjian
 * @since 2024年06月04日 19:27:44
 */
public class PinpointTraceContextLink implements JaMapContextLink<JaCoreContextEntity> {

    public static final String PinpointTraceIDKey = "Pinpoint-TraceID";
    public static final String PinpointSpanIDKey = "Pinpoint-pSpanID";

    @Override
    public void inherit(Map<String, String> source, JaCoreContextEntity target) {
        String traceId = source.get(JaMDC.TraceId);
        if (JaStringUtil.isEmpty(traceId)) {
            traceId = source.get(PinpointTraceIDKey);
            if (JaStringUtil.isNotEmpty(traceId)) {
                source.put(JaMDC.TraceId, traceId);
            }
        }
        JaMDC.put(JaStringUtil.isEmpty(traceId) ? JaMDC.createTraceId() : traceId);

        String requestId = source.get(JaMDC.RequestId);
        if (JaStringUtil.isEmpty(requestId)) {
            requestId = source.get(PinpointSpanIDKey);
            if (JaStringUtil.isNotEmpty(requestId)) {
                source.put(JaMDC.RequestId, requestId);
                JaMDC.putRequestId(requestId);
            }
        }
    }

    @Override
    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        // Do nothing
    }

    @Override
    public int order() {
        return -1000;
    }
}
