package com.jugg.agile.middleware.rabbitmq.spring;

import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
public class JaRabbitTemplateConfiguration implements InitializingBean {
    @Autowired(required = false)
    private List<RabbitTemplate> rabbitTemplateList;


    @Override
    public void afterPropertiesSet() throws Exception {
        JaNodeSpanRabbitTemplateProducer.transmitContext(rabbitTemplateList);
    }
}
