/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis.spring;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.lock.distributed.JaDistributedLock;
import com.jugg.agile.framework.core.lock.distributed.JaDistributedLockAdapter;
import com.jugg.agile.framework.core.lock.distributed.JaDistributedLockAspect;
import com.jugg.agile.middleware.redis.JaRedisLock;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration
public class JaRedisLockAdvisorRegistrar
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(@Nullable ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (Boolean.TRUE.equals(JaProperty.getBoolean((String)"ja.redis.lock.enabled", (Boolean)false))) {
            DefaultListableBeanFactory registry = (DefaultListableBeanFactory)beanFactory;
            AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
            advisor.setExpression("@annotation(" + JaDistributedLock.class.getName() + ")");
            advisor.setOrder(-11);
            advisor.setAdvice((Advice)new JaDistributedLockAspect());
            assert (registry != null);
            registry.registerSingleton("jaDistributedLockAspect", (Object)advisor);
            JaDistributedLockAdapter.setLockHandler(JaRedisLock::lock);
        }
    }
}

