package com.jugg.agile.middleware.redis.spring;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.aspect.JaAspectOrder;
import com.jugg.agile.framework.core.lock.distributed.JaDistributedLock;
import com.jugg.agile.framework.core.lock.distributed.JaDistributedLockAdapter;
import com.jugg.agile.framework.core.lock.distributed.JaDistributedLockAspect;
import com.jugg.agile.middleware.redis.JaRedisLock;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration
public class JaRedisLockAdvisorRegistrar implements BeanFactoryPostProcessor {
    @Override
    public void postProcessBeanFactory(@Nullable ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (Boolean.TRUE.equals(JaProperty.getBoolean("ja.redis.lock.enabled", false))) {
            DefaultListableBeanFactory registry = (DefaultListableBeanFactory) beanFactory;
            AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
            advisor.setExpression("@annotation(" + JaDistributedLock.class.getName() + ")");
            advisor.setOrder(JaAspectOrder.Lock);
            advisor.setAdvice(new JaDistributedLockAspect());
            assert registry != null;
            registry.registerSingleton("jaDistributedLockAspect", advisor);
            JaDistributedLockAdapter.setLockHandler(JaRedisLock::lock);
        }

    }
}
