package com.jugg.agile.middleware.redis.adapter.jedis.command;

import com.jugg.agile.middleware.redis.JaRedis;
import com.jugg.agile.middleware.redis.JaRedisLockCommand;
import com.jugg.agile.middleware.redis.adapter.jedis.pool.JedisSimplePool;
import com.jugg.agile.middleware.redis.meta.JaRedisConstants;

import java.util.Collections;

public class JaJedisSimpleLockCommand implements JaRedisLockCommand {


    /**
     * 上锁
     *
     * @param lockKey    需要获取的锁key
     * @param requestId  请求id
     * @param expireTime 过期时间 milliseconds
     * @return true:上锁成功, false:上锁失败
     */
    @Override
    public boolean lock(String lockKey, String requestId, long expireTime) {
        return JaRedis.setNx(lockKey, requestId, expireTime / 1000);
    }

    /**
     * 释放锁
     *
     * @param lockKey   释放的锁key
     * @param requestId 请求id
     * @return true:释放成功, false:释放失败
     */
    @Override
    public boolean unLock(String lockKey, String requestId) {
        return JaRedisConstants.LuaSuccess.equals(JedisSimplePool.get().eval(JaRedisConstants.LuaReleaseScript, Collections.singletonList(lockKey), Collections.singletonList(requestId)));
    }
}