/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis.adapter.jedis.command;

import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.redis.JaRedisCommand;
import com.jugg.agile.middleware.redis.adapter.jedis.pool.JedisSimplePool;
import redis.clients.jedis.Jedis;

public class JaJedisSimpleCommand
implements JaRedisCommand {
    @Override
    public Boolean set(String key, String value, Long ... seconds) {
        try (Jedis jedis = JedisSimplePool.get();){
            Boolean bl = "OK".equals(JaCollectionUtil.isEmpty((Object[])seconds) ? jedis.set(key, value) : jedis.setex(key, seconds[0].intValue(), value));
            return bl;
        }
    }

    @Override
    public Boolean setNx(String key, String value, Long ... seconds) {
        try (Jedis jedis = JedisSimplePool.get();){
            boolean result;
            boolean bl = result = 1L == jedis.setnx(key, value);
            if (result && JaCollectionUtil.isNotEmpty((Object[])seconds)) {
                this.expire(key, seconds[0]);
            }
            Boolean bl2 = result;
            return bl2;
        }
    }

    @Override
    public Boolean exists(String key) {
        try (Jedis jedis = JedisSimplePool.get();){
            Boolean bl = jedis.exists(key);
            return bl;
        }
    }

    @Override
    public Long del(String key) {
        try (Jedis jedis = JedisSimplePool.get();){
            Long l = jedis.del(key);
            return l;
        }
    }

    @Override
    public String get(String key) {
        try (Jedis jedis = JedisSimplePool.get();){
            String string = jedis.get(key);
            return string;
        }
    }

    @Override
    public Long expire(String key, Long seconds) {
        try (Jedis jedis = JedisSimplePool.get();){
            Long l = jedis.expire(key, seconds.intValue());
            return l;
        }
    }

    @Override
    public Long incr(String key, Long ... increment) {
        try (Jedis jedis = JedisSimplePool.get();){
            if (JaCollectionUtil.isEmpty((Object[])increment)) {
                Long l = jedis.incr(key);
                return l;
            }
            Long l = jedis.incrBy(key, increment[0].longValue());
            return l;
        }
    }

    @Override
    public Long decr(String key, Long ... increment) {
        try (Jedis jedis = JedisSimplePool.get();){
            if (JaCollectionUtil.isEmpty((Object[])increment)) {
                Long l = jedis.decr(key);
                return l;
            }
            Long l = jedis.decrBy(key, increment[0].longValue());
            return l;
        }
    }
}

