/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis.adapter.jedis.pool;

import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.redis.adapter.jedis.JedisPoolConfig;
import com.jugg.agile.middleware.redis.config.JaRedisConfig;
import com.jugg.agile.middleware.redis.config.JaRedisPoolConfig;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

public class JedisClusterPool {
    private static final JedisCluster jedisCluster;

    private JedisClusterPool() {
    }

    public static JedisCluster get() {
        return jedisCluster;
    }

    static {
        JaRedisConfig config = JaRedisConfig.load();
        JaRedisPoolConfig pool = config.getPool();
        String cluster = config.getCluster();
        if (JaStringUtil.isEmpty((String)cluster)) {
            throw new RuntimeException("redis cluster is null");
        }
        String[] clusterArray = cluster.split(",");
        HashSet<HostAndPort> hostAndPortsSet = new HashSet<HostAndPort>(clusterArray.length);
        for (String s : clusterArray) {
            if (!JaStringUtil.isNotEmpty((String)s)) continue;
            String[] hostAndPort = s.split(":");
            hostAndPortsSet.add(new HostAndPort(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
        }
        GenericObjectPoolConfig poolConfig = JedisPoolConfig.create(pool);
        String password = config.getPassword();
        jedisCluster = JaStringUtil.isEmpty((String)password) ? new JedisCluster(hostAndPortsSet, poolConfig) : new JedisCluster(hostAndPortsSet, config.getConnectionTimeout().intValue(), config.getSoTimeout().intValue(), config.getMaxAttempts().intValue(), password, poolConfig);
        JaShutdownHookUtil.add((String)"JedisCluster", () -> ((JedisCluster)jedisCluster).shutdown());
    }
}

