package com.jugg.agile.middleware.redis.adapter.spring.command;

import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.redis.JaRedisCommand;
import com.jugg.agile.middleware.redis.JaRedisMeta;
import com.jugg.agile.middleware.redis.adapter.jedis.pool.JedisClusterPool;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import lombok.SneakyThrows;
import org.springframework.data.redis.core.RedisTemplate;

public class JaSpringCommand implements JaRedisCommand {

    @Override
    public Boolean set(String key, String value, Long... seconds) {
        RedisTemplate bean = JaSpringBeanUtil.getBean(RedisTemplate.class);
        return JaRedisMeta.OK.equals(JaCollectionUtil.isEmpty(seconds)
                        ? JedisClusterPool.get().set(key, value)
//                : JedisClusterPool.get().setex(key, seconds[0], value)
                        : JedisClusterPool.get().setex(key, seconds[0].intValue(), value)
        );
    }

    @Override
    public Boolean setNx(String key, String value, Long... seconds) {
        boolean result = 1 == JedisClusterPool.get().setnx(key, value);
        if (result && JaCollectionUtil.isNotEmpty(seconds)) {
            expire(key, seconds[0]);
        }
        return result;
    }

    @Override
    public Long del(String key) {
        return JedisClusterPool.get().del(key);
    }

    @Override
    public Boolean exists(String key) {
        return JedisClusterPool.get().exists(key);
    }

    @Override
    @SneakyThrows
    public String get(String key) {
        return JedisClusterPool.get().get(key);
    }

    @Override
    public Long expire(String key, Long seconds) {
//        return JedisClusterPool.get().expire(key, seconds);
        return JedisClusterPool.get().expire(key, seconds.intValue());
    }

    @Override
    public Long incr(String key, Long... increment) {
        if (JaCollectionUtil.isEmpty(increment)) {
            return JedisClusterPool.get().incr(key);
        }
        return JedisClusterPool.get().incrBy(key, increment[0]);
    }

    @Override
    public Long decr(String key, Long... increment) {
        if (JaCollectionUtil.isEmpty(increment)) {
            return JedisClusterPool.get().decr(key);
        }
        return JedisClusterPool.get().decrBy(key, increment[0]);
    }
}
