/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaDapperLog;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.dapper.meta.RespSpan;
import com.jugg.agile.framework.core.meta.function.JaFunctionP;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.JaThrowableUtil;
import com.jugg.agile.framework.core.util.bytecode.proxy.JaProxyCglib;
import com.jugg.agile.framework.core.util.concurrent.JaConcurrentSubmit;
import com.jugg.agile.framework.core.util.concurrent.JaConcurrentTasks;
import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import com.jugg.agile.framework.core.util.io.serialize.json.adapter.jackson.migration.JacksonAutoType;
import com.jugg.agile.middleware.redis.JaRedisCommand;
import com.jugg.agile.middleware.redis.adapter.jedis.command.JaJedisClusterCommand;
import com.jugg.agile.middleware.redis.adapter.jedis.command.JaJedisSimpleCommand;
import com.jugg.agile.middleware.redis.adapter.jedis.pool.JedisSimplePool;
import com.jugg.agile.middleware.redis.adapter.spring.command.JaRedisTemplateCommand;
import com.jugg.agile.middleware.redis.config.JaRedisConfig;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.Callable;
import redis.clients.jedis.Jedis;

public class JaRedis {
    private static final String set = "set";
    private static final JaRedisCommand redisCommand;
    public static final JaThreadLocal<Boolean> SkipSpanThreadLocal;

    private JaRedis() {
    }

    public static <T> void setBigList(String key, List<T> list, int size, Long ... seconds) {
        List lists = JaCollectionUtil.splitBySize(list, (int)size);
        JaConcurrentTasks build = JaConcurrentTasks.build();
        int i = 0;
        while (i < size) {
            int finalI = i++;
            build.add(() -> JaRedis.setJson(key + "-" + finalI, lists.get(finalI), seconds));
        }
        build.add(() -> JaRedis.setT(key + "-size", size, seconds)).get();
    }

    public static <T> List<T> getBigList(String key, Type type) {
        Integer size = (Integer)JaRedis.getT(key + "-size");
        if (null == size) {
            return null;
        }
        JaConcurrentSubmit build = JaConcurrentSubmit.build();
        int i = 0;
        while (i < size) {
            int finalI = i++;
            build.add(() -> JaRedis.getByJson(key + "-" + finalI, type));
        }
        return build.get();
    }

    public static Boolean setString(String key, String value, Long ... seconds) {
        return redisCommand.set(key, value, seconds);
    }

    public static Boolean setNx(String key, String value, Long ... seconds) {
        return redisCommand.setNx(key, value, seconds);
    }

    public static <T> Boolean setT(String key, T value, Long ... seconds) {
        return redisCommand.set(key, JacksonAutoType.Instance.toString(value), seconds);
    }

    public static <T> Boolean setJson(String key, T value, Long ... seconds) {
        return redisCommand.set(key, JaJson.toString(value), seconds);
    }

    public static String getString(String key) {
        return redisCommand.get(key);
    }

    public static <T> T getByJson(String key, Type type) {
        String json = redisCommand.get(key);
        return (T)(JaStringUtil.isEmpty((String)json) ? null : JaJson.toObject((String)json, (Type)type));
    }

    public static <T> T getT(String key) {
        String json = redisCommand.get(key);
        return (T)(JaStringUtil.isEmpty((String)json) ? null : JacksonAutoType.Instance.toObject(json));
    }

    public static Long del(String key) {
        return redisCommand.del(key);
    }

    public static Boolean exists(String key) {
        return redisCommand.exists(key);
    }

    public static Long expire(String key, Long seconds) {
        return redisCommand.expire(key, seconds);
    }

    public static Long incr(String key, Long ... increment) {
        return redisCommand.incr(key, increment);
    }

    public static Long decr(String key, Long ... increment) {
        return redisCommand.decr(key, increment);
    }

    public static Object eval(String script, List<String> keys, List<String> args) {
        try (Jedis jedis = JedisSimplePool.get();){
            Object object = jedis.eval(script, keys, args);
            return object;
        }
    }

    public static <T> T cacheT(String key, Callable<T> callable, Long ... seconds) {
        return (T)JaRedis.cache(callable, () -> JaRedis.getT(key), value -> JaRedis.setT(key, value, seconds));
    }

    public static <T> T cacheJson(String key, Callable<T> callable, Type type, Long ... seconds) {
        return (T)JaRedis.cache(callable, () -> JaRedis.getByJson(key, type), value -> JaRedis.setJson(key, value, seconds));
    }

    public static <T> T cache(Callable<T> callable, Callable<T> get, JaFunctionP<T> set) {
        T t;
        try {
            t = get.call();
            if (null != t) {
                return t;
            }
        }
        catch (Throwable e) {
            JaLog.get().error("redis get error", e);
        }
        t = callable.call();
        if (null != t) {
            set.apply(t);
        }
        return t;
    }

    static {
        SkipSpanThreadLocal = new JaThreadLocal();
        try {
            Integer adapter = JaProperty.getInteger((String)"ja.redis.type", (Integer)4);
            if (4 == adapter) {
                redisCommand = new JaRedisTemplateCommand();
            } else {
                Class sourceClz = JaJedisSimpleCommand.class;
                switch (adapter) {
                    case 0: {
                        sourceClz = JaJedisClusterCommand.class;
                        break;
                    }
                    case 3: {
                        sourceClz = JaJedisSimpleCommand.class;
                        break;
                    }
                    default: {
                        JaThrowableUtil.throwRunLog((String)"ja.redis.adapter.base set error:{}", (Object[])new Object[]{adapter});
                    }
                }
                redisCommand = (JaRedisCommand)JaProxyCglib.newInstance(sourceClz, (proxyInstance, method, args, methodProxy, invokeHandler) -> {
                    String methodName = method.getName();
                    boolean skipSpan = null != SkipSpanThreadLocal.get() && (Boolean)SkipSpanThreadLocal.get() != false;
                    RespSpan respSpan = null;
                    if (!skipSpan) {
                        respSpan = ((RespSpan.RespSpanBuilder)RespSpan.builder().nodeSpan(NodeSpan.builder().nodeKind(NodeKind.Constant.Redis).id(methodName + " " + args[0]).build())).build();
                    }
                    try {
                        Object result = invokeHandler.invoke();
                        if (!skipSpan) {
                            respSpan.setResult(methodName.startsWith(set) ? args : result);
                        }
                        Object object = result;
                        return object;
                    }
                    catch (Throwable e) {
                        if (!skipSpan) {
                            respSpan.setThrowable(e);
                        } else {
                            JaLog.get().error(methodName + " " + args[0], e);
                        }
                        throw e;
                    }
                    finally {
                        if (!skipSpan) {
                            JaDapperLog.response(respSpan);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            JaLog.get().error("create redis error : {}", (Object)JaJson.toString((Object)JaRedisConfig.load()), (Object)e);
            throw e;
        }
    }
}

